package gov.va.med.mhv.getcare.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.converter.TreatmentFacilityConverter;
import gov.va.med.mhv.getcare.model.TreatmentFacility;
import gov.va.med.mhv.getcare.repository.TreatmentFacilityRepository;
import gov.va.med.mhv.getcare.service.TreatmentFacilityService;
import gov.va.med.mhv.getcare.validator.FacilityValidator;

@Component
public class TreatmentFacilityServiceImpl implements TreatmentFacilityService {
	private static Logger log = LogManager.getLogger(TreatmentFacilityServiceImpl.class);

	@Autowired
	private TreatmentFacilityRepository facilityRepository;

	@Autowired
	private FacilityValidator validator;

	@Override
	public ResponseUtil save(TreatmentFacilityDTO treatmentFacilityDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.facilityValidations(response, treatmentFacilityDTO);
		if (response.getValidationErrors().size() == 0) {
			TreatmentFacility facility = TreatmentFacilityConverter.convertTreatmentFacilityDTO(treatmentFacilityDTO);
			facilityRepository.save(facility);
			response.setSuccess(true);
		} else {
			log.debug("Validation Errors in Treatment Facility record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		facilityRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public TreatmentFacilityDTO findByPrimaryKey(Long id) {
		TreatmentFacilityDTO treatmentFacilityDTO = null;
		TreatmentFacility facility = facilityRepository.findOne(id);
		if (facility != null) {
			treatmentFacilityDTO = TreatmentFacilityConverter.convertTreatmentFacilityDomain(facility);
		} else {
			log.debug("Treatment Facility not found for id:");
			log.debug(id);
		}
		
		return treatmentFacilityDTO;
	}

	@Override
	public List<TreatmentFacilityDTO> findFacilitiesForUser(Long userprofileid) {
		List<TreatmentFacilityDTO> dtos = null;
		List<TreatmentFacility> facilities = facilityRepository.findFacilitiesForUser(userprofileid);
		if (facilities != null) {
			dtos = TreatmentFacilityConverter.convertTreatementFacilities(facilities);
		} else {
			log.debug("Facility Records not found for userprofileid:");
			log.debug(userprofileid);
		}

		return dtos;
	}

	@Override
	public List<TreatmentFacilityDTO> findDashBoardFacilitiesForUser(Long userprofileid) {
		List<TreatmentFacilityDTO> dtos = null;
		Pageable topFive = new PageRequest(0, 5);
		List<TreatmentFacility> facilities = facilityRepository.findDashboardFacilitiesForUser(userprofileid, topFive);
		if (facilities != null) {
			dtos = TreatmentFacilityConverter.convertTreatementFacilities(facilities);
		} else {
			log.debug("Dash Board Facility Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		
		return dtos;
	}
}
